/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

class VWAssociationLineRenderer {
    protected static Stroke m_normalStroke = null;
    protected static Stroke m_selectedStroke = null;
    private VWBaseAssociationUI m_association = null;
    private VWStepRouteColors m_stepRouteColors = null;
    private Point m_srcPt = null;
    private Point m_startPt = null;
    private Point m_endPt = null;
    private double m_angle = 0.0;

    protected VWAssociationLineRenderer(VWBaseAssociationUI association) {
        this.m_association = association;
        if (this.m_association != null) {
            this.m_stepRouteColors = this.m_association.getStepRouteColors();
        }
    }

    public boolean contains(Point loc) {
        double delta = 10.0;
        double toLocX = (double)this.m_endPt.x - (double)this.m_srcPt.x;
        double toLocY = (double)this.m_endPt.y - (double)this.m_srcPt.y;
        double locX = (double)loc.x - (double)this.m_srcPt.x;
        double locY = (double)loc.y - (double)this.m_srcPt.y;
        double distY = toLocX != 0.0 ? Math.abs(locY - toLocY / toLocX * locX) : Math.abs(locY);
        if (distY <= 10.0 && (toLocX < 0.0 ? locX >= toLocX && locX <= 0.0 : locX <= toLocX && locX >= 0.0)) {
            return true;
        }
        double distX = toLocY != 0.0 ? Math.abs(locX - toLocX / toLocY * locY) : Math.abs(locY);
        return distX <= 10.0 && (toLocY < 0.0 ? locY >= toLocY && locY <= 0.0 : locY <= toLocY && locY >= 0.0);
    }

    public Rectangle getBounds() {
        Rectangle rect = new Rectangle();
        rect.x = this.m_srcPt.x < this.m_endPt.x ? this.m_srcPt.x - 5 : this.m_endPt.x - 5;
        rect.y = this.m_srcPt.y < this.m_endPt.y ? this.m_srcPt.y - 5 : this.m_endPt.y - 5;
        rect.width = Math.abs(this.m_endPt.x - this.m_srcPt.x) + 10;
        rect.height = Math.abs(this.m_endPt.y - this.m_srcPt.y) + 20;
        return rect;
    }

    public void calcCoords() {
        Point destLoc = new Point();
        if (this.m_association.m_targetItem instanceof VWBaseStepUI) {
            destLoc = ((VWBaseStepUI)this.m_association.m_targetItem).getImageCenterLocation();
        } else if (this.m_association.m_targetItem instanceof VWBaseRouteUI) {
            destLoc = ((VWBaseRouteUI)this.m_association.m_targetItem).getCenterPoint();
        }
        this.m_srcPt = this.m_association.m_srcTextAnnotation.getImageCenterLocation();
        double horz = destLoc.x - this.m_srcPt.x;
        double vert = destLoc.y - this.m_srcPt.y;
        if (horz != 0.0) {
            this.m_angle = Math.atan(vert / horz);
            if (horz < 0.0) {
                this.m_angle = vert > 0.0 ? Math.PI + this.m_angle : -Math.PI + this.m_angle;
            }
        } else {
            this.m_angle = vert > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double reverseAngle = this.m_angle == 0.0 ? Math.PI : (this.m_angle > 0.0 ? this.m_angle - Math.PI : Math.PI + this.m_angle);
        this.m_startPt = this.m_association.m_srcTextAnnotation.getBoundaryPoint(this.m_angle);
        if (this.m_association.m_targetItem instanceof VWBaseStepUI) {
            this.m_endPt = ((VWBaseStepUI)this.m_association.m_targetItem).getBoundaryPoint(reverseAngle, true);
        } else if (this.m_association.m_targetItem instanceof VWBaseRouteUI) {
            this.m_endPt = ((VWBaseRouteUI)this.m_association.m_targetItem).getCenterPoint();
        }
    }

    public void paintComponent(Graphics g) {
        if (!this.m_association.m_srcTextAnnotation.contains(this.m_endPt)) {
            Color oldColor = g.getColor();
            if (this.m_association.getFocus()) {
                g.setColor(this.m_stepRouteColors.getFocusColor());
            } else if (this.m_association.getSelect()) {
                g.setColor(this.m_stepRouteColors.getSelectionColor());
            } else {
                g.setColor(this.m_stepRouteColors.getDefaultColor());
            }
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(this.getDashedStroke());
            }
            g.drawLine(this.m_startPt.x, this.m_startPt.y, this.m_endPt.x, this.m_endPt.y);
            if (oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
            g.setColor(oldColor);
        }
    }

    public void printComponent(Graphics2D g2, int pageX, int pageY) {
        if (!this.m_association.m_srcTextAnnotation.contains(this.m_endPt)) {
            Color curColor = g2.getColor();
            g2.setColor(Color.black);
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.getDashedStroke());
            g2.drawLine(this.m_startPt.x - pageX, this.m_startPt.y - pageY, this.m_endPt.x - pageX, this.m_endPt.y - pageY);
            if (oldStroke != null) {
                g2.setStroke(oldStroke);
            }
            g2.setColor(curColor);
        }
    }

    public Stroke getDashedStroke() {
        if (this.m_association.getFocus() || this.m_association.getSelect()) {
            if (m_selectedStroke == null) {
                float[] dash = new float[]{5.0f};
                m_selectedStroke = new BasicStroke(2.0f, 0, 0, 5.0f, dash, 0.0f);
            }
            return m_selectedStroke;
        }
        if (m_normalStroke == null) {
            float[] dash = new float[]{5.0f};
            m_normalStroke = new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f);
        }
        return m_normalStroke;
    }

    public Point getPoint(double dist) {
        double deltaY = this.m_endPt.y - this.m_srcPt.y;
        double deltaX = this.m_endPt.x - this.m_srcPt.x;
        double len = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
        if (dist >= len) {
            return null;
        }
        Point pt = new Point(0, 0);
        pt.x = (int)(dist / len * deltaX) + this.m_srcPt.x;
        pt.y = (int)(dist / len * deltaY) + this.m_srcPt.y;
        return pt;
    }

    public Point getPoint(int percent) {
        if (percent < 0 || percent > 100) {
            return null;
        }
        double deltaY = this.m_endPt.y - this.m_srcPt.y;
        double deltaX = this.m_endPt.x - this.m_srcPt.x;
        Point pt = new Point(0, 0);
        double dPercent = (double)percent / 100.0;
        pt.x = (int)(dPercent * deltaX) + this.m_srcPt.x;
        pt.y = (int)(dPercent * deltaY) + this.m_srcPt.y;
        return pt;
    }

    public Point getCenterPoint() {
        Point pt = new Point(0, 0);
        double deltaY = this.m_endPt.y - this.m_startPt.y;
        double deltaX = this.m_endPt.x - this.m_startPt.x;
        pt.x = (int)(deltaX / 2.0) + this.m_startPt.x;
        pt.y = (int)(deltaY / 2.0) + this.m_startPt.y;
        return pt;
    }
}

